/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.software;

import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.HLE.Modules;
import jpcsp.Memory;
import jpcsp.graphics.GeContext;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.RE.software.IRandomTextureAccess;
import jpcsp.graphics.VideoEngine;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.ImageReader;
import jpcsp.util.Utilities;

public abstract class CachedTexture
implements IRandomTextureAccess {
    protected int width;
    protected int height;
    protected final int pixelFormat;
    protected final int widthPower2;
    protected final int heightPower2;
    protected final int offset;
    protected int[] buffer;
    protected boolean useTextureClut;
    protected int[] clut;
    protected boolean isVRAMTexture;

    public static CachedTexture getCachedTexture(int width, int height, int pixelFormat, IMemoryReader imageReader) {
        CachedTexture cachedTexture = CachedTexture.getCachedTexture(width, height, pixelFormat, 0);
        cachedTexture.setBuffer(imageReader);
        return cachedTexture;
    }

    public static CachedTexture getCachedTexture(int width, int height, int pixelFormat, int[] buffer, int bufferOffset, int bufferLength) {
        int textureAddress;
        int textureAddress2;
        int offset = 0;
        if (buffer == RuntimeContext.getMemoryInt() && (pixelFormat == 3 || IRenderingEngine.isTextureTypeIndexed[pixelFormat]) && !Modules.sceDisplayModule.isGeAddress(textureAddress2 = bufferOffset << 2)) {
            offset = bufferOffset;
        }
        CachedTexture cachedTexture = CachedTexture.getCachedTexture(width, height, pixelFormat, offset);
        cachedTexture.setBuffer(buffer, bufferOffset, bufferLength);
        if (buffer == RuntimeContext.getMemoryInt() && Memory.isVRAM(textureAddress = bufferOffset << 2)) {
            cachedTexture.setVRAMTexture(true);
        }
        return cachedTexture;
    }

    public static CachedTexture getCachedTexture(int width, int height, int pixelFormat, short[] buffer, int bufferOffset, int bufferLength) {
        CachedTexture cachedTexture = CachedTexture.getCachedTexture(width, height, pixelFormat, 0);
        cachedTexture.setBuffer(buffer, bufferOffset, bufferLength);
        return cachedTexture;
    }

    private static CachedTexture getCachedTexture(int width, int height, int pixelFormat, int offset) {
        CachedTexture cachedTexture;
        if (IRenderingEngine.isTextureTypeIndexed[pixelFormat]) {
            switch (pixelFormat) {
                case 5: {
                    cachedTexture = new CachedTextureIndexed8Bit(width, height, pixelFormat, offset);
                    break;
                }
                case 6: {
                    cachedTexture = new CachedTextureIndexed16Bit(width, height, pixelFormat, offset);
                    break;
                }
                case 7: {
                    cachedTexture = new CachedTextureIndexed32Bit(width, height, pixelFormat, offset);
                    break;
                }
                default: {
                    VideoEngine.log.error((Object)String.format("CachedTexture: unsupported indexed texture format %d", pixelFormat));
                    return null;
                }
            }
            ((CachedTexture)cachedTexture).setClut();
        } else {
            cachedTexture = width == Utilities.makePow2(width) ? (offset == 0 ? new CachedTexturePow2(width, height, pixelFormat) : new CachedTextureOffsetPow2(width, height, pixelFormat, offset)) : (offset == 0 ? new CachedTextureNonPow2(width, height, pixelFormat) : new CachedTextureOffsetNonPow2(width, height, pixelFormat, offset));
        }
        return cachedTexture;
    }

    protected CachedTexture(int width, int height, int pixelFormat, int offset) {
        this.width = width;
        this.height = height;
        this.pixelFormat = pixelFormat;
        this.offset = offset;
        this.widthPower2 = Utilities.getPower2(width);
        this.heightPower2 = Utilities.getPower2(height);
    }

    protected void setBuffer(IMemoryReader imageReader) {
        this.buffer = new int[this.width * this.height];
        for (int i = 0; i < this.buffer.length; ++i) {
            this.buffer[i] = imageReader.readNext();
        }
    }

    protected void setBuffer(int[] buffer, int bufferOffset, int bufferLength) {
        switch (this.pixelFormat) {
            case 0: {
                this.buffer = new int[bufferLength * 2];
                int j = 0;
                for (int i = 0; i < bufferLength; ++i) {
                    int color = buffer[bufferOffset + i];
                    this.buffer[j++] = ImageReader.color565to8888(color & 0xFFFF);
                    this.buffer[j++] = ImageReader.color565to8888(color >>> 16);
                }
                break;
            }
            case 1: {
                this.buffer = new int[bufferLength * 2];
                int j = 0;
                for (int i = 0; i < bufferLength; ++i) {
                    int color = buffer[bufferOffset + i];
                    this.buffer[j++] = ImageReader.color5551to8888(color & 0xFFFF);
                    this.buffer[j++] = ImageReader.color5551to8888(color >>> 16);
                }
                break;
            }
            case 2: {
                this.buffer = new int[bufferLength * 2];
                int j = 0;
                for (int i = 0; i < bufferLength; ++i) {
                    int color = buffer[bufferOffset + i];
                    this.buffer[j++] = ImageReader.color4444to8888(color & 0xFFFF);
                    this.buffer[j++] = ImageReader.color4444to8888(color >>> 16);
                }
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                if (buffer == RuntimeContext.getMemoryInt() && this.offset == bufferOffset) {
                    this.buffer = buffer;
                    break;
                }
                this.buffer = new int[bufferLength];
                System.arraycopy(buffer, bufferOffset, this.buffer, 0, bufferLength);
                break;
            }
            default: {
                VideoEngine.log.error((Object)String.format("CachedTexture setBuffer int unsupported pixel format %d", this.pixelFormat));
            }
        }
    }

    protected void setClut() {
    }

    protected void setBuffer(short[] buffer, int bufferOffset, int bufferLength) {
        switch (this.pixelFormat) {
            case 0: {
                this.buffer = new int[bufferLength];
                for (int i = 0; i < bufferLength; ++i) {
                    this.buffer[i] = ImageReader.color565to8888(buffer[bufferOffset + i] & 0xFFFF);
                }
                break;
            }
            case 1: {
                this.buffer = new int[bufferLength];
                for (int i = 0; i < bufferLength; ++i) {
                    this.buffer[i] = ImageReader.color5551to8888(buffer[bufferOffset + i] & 0xFFFF);
                }
                break;
            }
            case 2: {
                this.buffer = new int[bufferLength];
                for (int i = 0; i < bufferLength; ++i) {
                    this.buffer[i] = ImageReader.color4444to8888(buffer[bufferOffset + i] & 0xFFFF);
                }
                break;
            }
            case 3: {
                this.buffer = new int[bufferLength / 2];
                int j = bufferOffset;
                for (int i = 0; i < this.buffer.length; ++i) {
                    this.buffer[i] = buffer[j++] & 0xFFFF | buffer[j++] << 16;
                }
            }
            default: {
                VideoEngine.log.error((Object)String.format("CachedTexture setBuffer short unsupported pixel format %d", this.pixelFormat));
            }
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public int getPixelFormat() {
        return this.pixelFormat;
    }

    public boolean isVRAMTexture() {
        return this.isVRAMTexture;
    }

    public void setVRAMTexture(boolean isVRAMTexture) {
        this.isVRAMTexture = isVRAMTexture;
    }

    public String toString() {
        return String.format("CachedTexture[(%d x %d), %s]", this.getWidth(), this.getHeight(), VideoEngine.getPsmName(this.getPixelFormat()));
    }

    private static class CachedTextureIndexed32Bit
    extends CachedTextureIndexed {
        protected CachedTextureIndexed32Bit(int width, int height, int pixelFormat, int offset) {
            super(width, height, pixelFormat, offset);
        }

        @Override
        public int readPixel(int u, int v) {
            int pixelIndex = v * this.width + u;
            int index = this.buffer[pixelIndex + this.offset];
            return this.getClut(index);
        }
    }

    private static class CachedTextureIndexed16Bit
    extends CachedTextureIndexed {
        private static final int[] shift16Bit = new int[]{0, 16};

        protected CachedTextureIndexed16Bit(int width, int height, int pixelFormat, int offset) {
            super(width, height, pixelFormat, offset);
        }

        @Override
        public int readPixel(int u, int v) {
            int pixelIndex = v * this.width + u;
            int index = this.buffer[(pixelIndex >> 1) + this.offset] >> shift16Bit[pixelIndex & 1];
            return this.getClut(index & 0xFFFF);
        }
    }

    private static class CachedTextureIndexed8Bit
    extends CachedTextureIndexed {
        private static final int[] shift8Bit = new int[]{0, 8, 16, 24};

        protected CachedTextureIndexed8Bit(int width, int height, int pixelFormat, int offset) {
            super(width, height, pixelFormat, offset);
        }

        @Override
        public int readPixel(int u, int v) {
            int pixelIndex = v * this.width + u;
            int index = this.buffer[(pixelIndex >> 2) + this.offset] >> shift8Bit[pixelIndex & 3];
            return this.getClut(index & 0xFF);
        }
    }

    private static abstract class CachedTextureIndexed
    extends CachedTexture {
        private int[] clut;
        private int shift;
        private int mask;
        private int start;

        protected CachedTextureIndexed(int width, int height, int pixelFormat, int offset) {
            super(width, height, pixelFormat, offset);
        }

        protected int getClut(int index) {
            return this.clut[index >> this.shift & this.mask | this.start << 4];
        }

        public void setClut(int[] clut, int shift, int mask, int start) {
            this.clut = clut;
            this.shift = shift;
            this.mask = mask;
            this.start = start;
        }

        @Override
        public void setClut() {
            VideoEngine videoEngine = VideoEngine.getInstance();
            GeContext context = videoEngine.getContext();
            int clutNumEntries = videoEngine.getClutNumEntries();
            int[] clut = null;
            switch (context.tex_clut_mode) {
                case 0: {
                    short[] shortClut = videoEngine.readClut16(0);
                    clut = new int[clutNumEntries];
                    for (int i = 0; i < clut.length; ++i) {
                        clut[i] = ImageReader.color565to8888(shortClut[i]);
                    }
                    break;
                }
                case 1: {
                    short[] shortClut = videoEngine.readClut16(0);
                    clut = new int[clutNumEntries];
                    for (int i = 0; i < clut.length; ++i) {
                        clut[i] = ImageReader.color5551to8888(shortClut[i]);
                    }
                    break;
                }
                case 2: {
                    short[] shortClut = videoEngine.readClut16(0);
                    clut = new int[clutNumEntries];
                    for (int i = 0; i < clut.length; ++i) {
                        clut[i] = ImageReader.color4444to8888(shortClut[i]);
                    }
                    break;
                }
                case 3: {
                    int[] intClut = videoEngine.readClut32(0);
                    clut = new int[clutNumEntries];
                    System.arraycopy(intClut, 0, clut, 0, clut.length);
                }
            }
            if (clut != null) {
                this.setClut(clut, context.tex_clut_shift, context.tex_clut_mask, context.tex_clut_start);
            }
        }
    }

    private static class CachedTextureOffsetNonPow2
    extends CachedTexture {
        public CachedTextureOffsetNonPow2(int width, int height, int pixelFormat, int offset) {
            super(width, height, pixelFormat, offset);
        }

        @Override
        public int readPixel(int u, int v) {
            return this.buffer[v * this.width + u + this.offset];
        }
    }

    private static class CachedTextureNonPow2
    extends CachedTexture {
        public CachedTextureNonPow2(int width, int height, int pixelFormat) {
            super(width, height, pixelFormat, 0);
        }

        @Override
        public int readPixel(int u, int v) {
            return this.buffer[v * this.width + u];
        }
    }

    private static class CachedTextureOffsetPow2
    extends CachedTexture {
        public CachedTextureOffsetPow2(int width, int height, int pixelFormat, int offset) {
            super(width, height, pixelFormat, offset);
        }

        @Override
        public int readPixel(int u, int v) {
            return this.buffer[(v << this.widthPower2) + u + this.offset];
        }
    }

    protected static class CachedTexturePow2
    extends CachedTexture {
        public CachedTexturePow2(int widthPow2, int heightPow2, int width, int height, int pixelFormat) {
            super(widthPow2, heightPow2, pixelFormat, 0);
            this.width = width;
            this.height = height;
        }

        public CachedTexturePow2(int width, int height, int pixelFormat) {
            super(width, height, pixelFormat, 0);
        }

        @Override
        public int readPixel(int u, int v) {
            return this.buffer[(v << this.widthPower2) + u];
        }
    }
}

